---@meta

---@class ACameraCalibrationCheckerboard : AActor
---@field Root USceneComponent
---@field TopLeft UCalibrationPointComponent
---@field TopRight UCalibrationPointComponent
---@field BottomLeft UCalibrationPointComponent
---@field BottomRight UCalibrationPointComponent
---@field Center UCalibrationPointComponent
---@field NumCornerRows int32
---@field NumCornerCols int32
---@field SquareSideLength float
---@field Thickness float
---@field CubeMesh UStaticMesh
---@field OddCubeMaterial UMaterialInterface
---@field EvenCubeMaterial UMaterialInterface
local ACameraCalibrationCheckerboard = {}

function ACameraCalibrationCheckerboard:Rebuild() end


---@class FAnamorphicDistortionParameters
---@field PixelAspect float
---@field CX02 float
---@field CX04 float
---@field CX22 float
---@field CX24 float
---@field CX44 float
---@field CY02 float
---@field CY04 float
---@field CY22 float
---@field CY24 float
---@field CY44 float
---@field SqueezeX float
---@field SqueezeY float
---@field LensRotation float
local FAnamorphicDistortionParameters = {}



---@class FBaseFocusPoint
local FBaseFocusPoint = {}


---@class FBaseLensTable
---@field LensFile TWeakObjectPtr<ULensFile>
local FBaseLensTable = {}



---@class FCalibratedMapFormat
---@field PixelOrigin ECalibratedMapPixelOrigin
---@field UndistortionChannels ECalibratedMapChannels
---@field DistortionChannels ECalibratedMapChannels
local FCalibratedMapFormat = {}



---@class FCameraFeedInfo
---@field Dimensions FIntPoint
---@field AspectRatio float
local FCameraFeedInfo = {}



---@class FDataTablePointInfoBase
---@field Focus float
---@field Zoom float
local FDataTablePointInfoBase = {}



---@class FDerivedDistortionData
---@field DistortionData FDistortionData
---@field UndistortionDisplacementMap UTextureRenderTarget2D
---@field DistortionDisplacementMap UTextureRenderTarget2D
local FDerivedDistortionData = {}



---@class FDistortionCalibrationResult
---@field EvaluatedFocus float
---@field EvaluatedZoom float
---@field ReprojectionError double
---@field FocalLength FFocalLengthInfo
---@field ImageCenter FImageCenterInfo
---@field Parameters FDistortionInfo
---@field STMap FSTMapInfo
---@field STMapFullPath FString
---@field ErrorMessage FText
local FDistortionCalibrationResult = {}



---@class FDistortionData
---@field DistortedUVs TArray<FVector2D>
---@field OverscanFactor float
local FDistortionData = {}



---@class FDistortionFocusPoint : FBaseFocusPoint
---@field Focus float
---@field MapBlendingCurve FRichCurve
---@field ZoomPoints TArray<FDistortionZoomPoint>
local FDistortionFocusPoint = {}



---@class FDistortionHandlerPicker
---@field TargetCameraComponent UCineCameraComponent
---@field DistortionProducerID FGuid
---@field HandlerDisplayName FString
local FDistortionHandlerPicker = {}



---@class FDistortionInfo
---@field Parameters TArray<float>
local FDistortionInfo = {}



---@class FDistortionPointInfo : FDataTablePointInfoBase
---@field DistortionInfo FDistortionInfo
local FDistortionPointInfo = {}



---@class FDistortionTable : FBaseLensTable
---@field FocusPoints TArray<FDistortionFocusPoint>
local FDistortionTable = {}



---@class FDistortionZoomPoint
---@field Zoom float
---@field DistortionInfo FDistortionInfo
local FDistortionZoomPoint = {}



---@class FEncodersTable
---@field Focus FRichCurve
---@field Iris FRichCurve
local FEncodersTable = {}



---@class FFocalLengthFocusPoint : FBaseFocusPoint
---@field Focus float
---@field Fx FRichCurve
---@field Fy FRichCurve
---@field ZoomPoints TArray<FFocalLengthZoomPoint>
local FFocalLengthFocusPoint = {}



---@class FFocalLengthInfo
---@field FxFy FVector2D
local FFocalLengthInfo = {}



---@class FFocalLengthPointInfo : FDataTablePointInfoBase
---@field FocalLengthInfo FFocalLengthInfo
local FFocalLengthPointInfo = {}



---@class FFocalLengthTable : FBaseLensTable
---@field FocusPoints TArray<FFocalLengthFocusPoint>
local FFocalLengthTable = {}



---@class FFocalLengthZoomPoint
---@field Zoom float
---@field FocalLengthInfo FFocalLengthInfo
---@field bIsCalibrationPoint boolean
local FFocalLengthZoomPoint = {}



---@class FImageCenterFocusPoint : FBaseFocusPoint
---@field Focus float
---@field Cx FRichCurve
---@field Cy FRichCurve
local FImageCenterFocusPoint = {}



---@class FImageCenterInfo
---@field PrincipalPoint FVector2D
local FImageCenterInfo = {}



---@class FImageCenterPointInfo : FDataTablePointInfoBase
---@field ImageCenterInfo FImageCenterInfo
local FImageCenterPointInfo = {}



---@class FImageCenterTable : FBaseLensTable
---@field FocusPoints TArray<FImageCenterFocusPoint>
local FImageCenterTable = {}



---@class FLensDataCategoryEditorColor
---@field Focus FColor
---@field Iris FColor
---@field Zoom FColor
---@field Distortion FColor
---@field ImageCenter FColor
---@field STMap FColor
---@field NodalOffset FColor
local FLensDataCategoryEditorColor = {}



---@class FLensDistortionState
---@field DistortionInfo FDistortionInfo
---@field FocalLengthInfo FFocalLengthInfo
---@field ImageCenter FImageCenterInfo
local FLensDistortionState = {}



---@class FLensFileEvaluationInputs
---@field Focus float
---@field Iris float
---@field Zoom float
---@field Filmback FCameraFilmbackSettings
---@field bIsValid boolean
local FLensFileEvaluationInputs = {}



---@class FLensFilePicker
---@field bUseDefaultLensFile boolean
---@field LensFile ULensFile
local FLensFilePicker = {}



---@class FLensInfo
---@field LensModelName FString
---@field LensSerialNumber FString
---@field LensModel TSubclassOf<ULensModel>
---@field SensorDimensions FVector2D
---@field ImageDimensions FIntPoint
---@field SqueezeFactor float
local FLensInfo = {}



---@class FNodalOffsetFocusPoint : FBaseFocusPoint
---@field Focus float
---@field LocationOffset FRichCurve
---@field RotationOffset FRichCurve
local FNodalOffsetFocusPoint = {}



---@class FNodalOffsetPointInfo : FDataTablePointInfoBase
---@field NodalPointOffset FNodalPointOffset
local FNodalOffsetPointInfo = {}



---@class FNodalOffsetTable : FBaseLensTable
---@field FocusPoints TArray<FNodalOffsetFocusPoint>
local FNodalOffsetTable = {}



---@class FNodalPointOffset
---@field LocationOffset FVector
---@field RotationOffset FQuat
local FNodalPointOffset = {}



---@class FSTMapFocusPoint : FBaseFocusPoint
---@field Focus float
---@field MapBlendingCurve FRichCurve
---@field ZoomPoints TArray<FSTMapZoomPoint>
local FSTMapFocusPoint = {}



---@class FSTMapInfo
---@field DistortionMap UTexture
---@field MapFormat FCalibratedMapFormat
local FSTMapInfo = {}



---@class FSTMapPointInfo : FDataTablePointInfoBase
---@field STMapInfo FSTMapInfo
local FSTMapPointInfo = {}



---@class FSTMapTable : FBaseLensTable
---@field FocusPoints TArray<FSTMapFocusPoint>
local FSTMapTable = {}



---@class FSTMapZoomPoint
---@field Zoom float
---@field STMapInfo FSTMapInfo
---@field DerivedDistortionData FDerivedDistortionData
---@field bIsCalibrationPoint boolean
local FSTMapZoomPoint = {}



---@class FSimulcamInfo
---@field MediaResolution FIntPoint
---@field MediaPlateAspectRatio float
---@field CGLayerAspectRatio float
local FSimulcamInfo = {}



---@class FSphericalDistortionParameters
---@field K1 float
---@field K2 float
---@field K3 float
---@field P1 float
---@field P2 float
local FSphericalDistortionParameters = {}



---@class UAnamorphicLensDistortionModelHandler : ULensDistortionModelHandlerBase
local UAnamorphicLensDistortionModelHandler = {}


---@class UAnamorphicLensModel : ULensModel
local UAnamorphicLensModel = {}


---@class UCalibrationPointComponent : UProceduralMeshComponent
---@field SubPoints TMap<FString, FVector>
---@field bVisualizePointsInEditor boolean
---@field PointVisualizationScale float
---@field VisualizationShape ECalibrationPointVisualization
local UCalibrationPointComponent = {}

function UCalibrationPointComponent:RebuildVertices() end
---@param InSubpointName FString
---@param OutNamespacedName FString
---@return boolean
function UCalibrationPointComponent:NamespacedSubpointName(InSubpointName, OutNamespacedName) end
---@param InPointName FString
---@param OutLocation FVector
---@return boolean
function UCalibrationPointComponent:GetWorldLocation(InPointName, OutLocation) end
---@param OutNamespacedNames TArray<FString>
function UCalibrationPointComponent:GetNamespacedPointNames(OutNamespacedNames) end


---@class UCameraCalibrationEditorSettings : UDeveloperSettings
local UCameraCalibrationEditorSettings = {}


---@class UCameraCalibrationSettings : UDeveloperSettings
---@field StartupLensFile TSoftObjectPtr<ULensFile>
---@field DisplacementMapResolution FIntPoint
---@field CalibrationInputTolerance float
---@field DefaultUndistortionDisplacementMaterials TMap<TSubclassOf<ULensDistortionModelHandlerBase>, TSoftObjectPtr<UMaterialInterface>>
---@field DefaultDistortionDisplacementMaterials TMap<TSubclassOf<ULensDistortionModelHandlerBase>, TSoftObjectPtr<UMaterialInterface>>
---@field DefaultDistortionMaterials TMap<TSubclassOf<ULensDistortionModelHandlerBase>, TSoftObjectPtr<UMaterialInterface>>
---@field bEnableCalibrationDatasetImportExport boolean
local UCameraCalibrationSettings = {}



---@class UCameraCalibrationStep : UObject
local UCameraCalibrationStep = {}


---@class UCameraCalibrationSubsystem : UEngineSubsystem
---@field DefaultLensFile ULensFile
---@field LensModelMap TMap<FName, TSubclassOf<ULensModel>>
---@field CameraNodalOffsetAlgosMap TMap<FName, TSubclassOf<UCameraNodalOffsetAlgo>>
---@field CameraImageCenterAlgosMap TMap<FName, TSubclassOf<UCameraImageCenterAlgo>>
---@field CameraCalibrationStepsMap TMap<FName, TSubclassOf<UCameraCalibrationStep>>
local UCameraCalibrationSubsystem = {}

---@param Component UCineCameraComponent
---@param Handler ULensDistortionModelHandlerBase
function UCameraCalibrationSubsystem:UnregisterDistortionModelHandler(Component, Handler) end
---@param NewDefaultLensFile ULensFile
function UCameraCalibrationSubsystem:SetDefaultLensFile(NewDefaultLensFile) end
---@param ModelName FName
---@return TSubclassOf<ULensModel>
function UCameraCalibrationSubsystem:GetRegisteredLensModel(ModelName) end
---@return TArray<FName>
function UCameraCalibrationSubsystem:GetOverlayMaterialNames() end
---@param OverlayName FName
---@return UMaterialInterface
function UCameraCalibrationSubsystem:GetOverlayMaterial(OverlayName) end
---@param Picker FLensFilePicker
---@return ULensFile
function UCameraCalibrationSubsystem:GetLensFile(Picker) end
---@param Component UCineCameraComponent
---@return TArray<ULensDistortionModelHandlerBase>
function UCameraCalibrationSubsystem:GetDistortionModelHandlers(Component) end
---@return ULensFile
function UCameraCalibrationSubsystem:GetDefaultLensFile() end
---@return TArray<FName>
function UCameraCalibrationSubsystem:GetCameraNodalOffsetAlgos() end
---@param Name FName
---@return TSubclassOf<UCameraNodalOffsetAlgo>
function UCameraCalibrationSubsystem:GetCameraNodalOffsetAlgo(Name) end
---@return TArray<FName>
function UCameraCalibrationSubsystem:GetCameraImageCenterAlgos() end
---@param Name FName
---@return TSubclassOf<UCameraImageCenterAlgo>
function UCameraCalibrationSubsystem:GetCameraImageCenterAlgo(Name) end
---@return TArray<FName>
function UCameraCalibrationSubsystem:GetCameraCalibrationSteps() end
---@param Name FName
---@return TSubclassOf<UCameraCalibrationStep>
function UCameraCalibrationSubsystem:GetCameraCalibrationStep(Name) end
---@param DistortionHandlerPicker FDistortionHandlerPicker
---@param LensModelClass TSubclassOf<ULensModel>
---@return ULensDistortionModelHandlerBase
function UCameraCalibrationSubsystem:FindOrCreateDistortionModelHandler(DistortionHandlerPicker, LensModelClass) end
---@param DistortionHandlerPicker FDistortionHandlerPicker
---@param bUpdatePicker boolean
---@return ULensDistortionModelHandlerBase
function UCameraCalibrationSubsystem:FindDistortionModelHandler(DistortionHandlerPicker, bUpdatePicker) end


---@class UCameraImageCenterAlgo : UObject
local UCameraImageCenterAlgo = {}


---@class UCameraLensDistortionAlgo : UObject
local UCameraLensDistortionAlgo = {}


---@class UCameraNodalOffsetAlgo : UObject
local UCameraNodalOffsetAlgo = {}


---@class ULensDistortionModelHandlerBase : UObject
---@field LensModelClass TSubclassOf<ULensModel>
---@field DistortionPostProcessMID UMaterialInstanceDynamic
---@field CurrentState FLensDistortionState
---@field CameraFilmback FCameraFilmbackSettings
---@field DisplayName FString
---@field OverscanFactor float
---@field UndistortionDisplacementMapMID UMaterialInstanceDynamic
---@field DistortionDisplacementMapMID UMaterialInstanceDynamic
---@field UndistortionDisplacementMapRT UTextureRenderTarget2D
---@field DistortionDisplacementMapRT UTextureRenderTarget2D
---@field DistortionProducerID FGuid
local ULensDistortionModelHandlerBase = {}

---@param InNewState FLensDistortionState
function ULensDistortionModelHandlerBase:SetDistortionState(InNewState) end
---@param ModelToSupport TSubclassOf<ULensModel>
---@return boolean
function ULensDistortionModelHandlerBase:IsModelSupported(ModelToSupport) end
---@return UTextureRenderTarget2D
function ULensDistortionModelHandlerBase:GetUndistortionDisplacementMap() end
---@return UTextureRenderTarget2D
function ULensDistortionModelHandlerBase:GetDistortionDisplacementMap() end


---@class ULensFile : UObject
---@field LensInfo FLensInfo
---@field DataMode ELensDataMode
---@field UserMetadata TMap<FString, FString>
---@field EncodersTable FEncodersTable
---@field DistortionTable FDistortionTable
---@field FocalLengthTable FFocalLengthTable
---@field ImageCenterTable FImageCenterTable
---@field NodalOffsetTable FNodalOffsetTable
---@field STMapTable FSTMapTable
---@field UndistortionDisplacementMapHolders TArray<UTextureRenderTarget2D>
---@field DistortionDisplacementMapHolders TArray<UTextureRenderTarget2D>
local ULensFile = {}

---@param InDataCategory ELensDataCategory
---@param InFocus float
---@param InZoom float
function ULensFile:RemoveZoomPoint(InDataCategory, InFocus, InZoom) end
---@param InDataCategory ELensDataCategory
---@param InFocus float
function ULensFile:RemoveFocusPoint(InDataCategory, InFocus) end
---@param InDataCategory ELensDataCategory
---@return boolean
function ULensFile:HasSamples(InDataCategory) end
---@return boolean
function ULensFile:HasIrisEncoderMapping() end
---@return boolean
function ULensFile:HasFocusEncoderMapping() end
---@param InDataCategory ELensDataCategory
---@return int32
function ULensFile:GetTotalPointNum(InDataCategory) end
---@return TArray<FSTMapPointInfo>
function ULensFile:GetSTMapPoints() end
---@param InFocus float
---@param InZoom float
---@param OutSTMapInfo FSTMapInfo
---@return boolean
function ULensFile:GetSTMapPoint(InFocus, InZoom, OutSTMapInfo) end
---@return TArray<FNodalOffsetPointInfo>
function ULensFile:GetNodalOffsetPoints() end
---@param InFocus float
---@param InZoom float
---@param OutNodalPointOffset FNodalPointOffset
---@return boolean
function ULensFile:GetNodalOffsetPoint(InFocus, InZoom, OutNodalPointOffset) end
---@return TArray<FImageCenterPointInfo>
function ULensFile:GetImageCenterPoints() end
---@param InFocus float
---@param InZoom float
---@param OutImageCenterInfo FImageCenterInfo
---@return boolean
function ULensFile:GetImageCenterPoint(InFocus, InZoom, OutImageCenterInfo) end
---@return TArray<FFocalLengthPointInfo>
function ULensFile:GetFocalLengthPoints() end
---@param InFocus float
---@param InZoom float
---@param OutFocalLengthInfo FFocalLengthInfo
---@return boolean
function ULensFile:GetFocalLengthPoint(InFocus, InZoom, OutFocalLengthInfo) end
---@return TArray<FDistortionPointInfo>
function ULensFile:GetDistortionPoints() end
---@param InFocus float
---@param InZoom float
---@param OutDistortionInfo FDistortionInfo
---@return boolean
function ULensFile:GetDistortionPoint(InFocus, InZoom, OutDistortionInfo) end
---@param InNormalizedValue float
---@return float
function ULensFile:EvaluateNormalizedIris(InNormalizedValue) end
---@param InNormalizedValue float
---@return float
function ULensFile:EvaluateNormalizedFocus(InNormalizedValue) end
---@param InFocus float
---@param InZoom float
---@param OutEvaluatedValue FNodalPointOffset
---@return boolean
function ULensFile:EvaluateNodalPointOffset(InFocus, InZoom, OutEvaluatedValue) end
---@param InFocus float
---@param InZoom float
---@param OutEvaluatedValue FImageCenterInfo
---@return boolean
function ULensFile:EvaluateImageCenterParameters(InFocus, InZoom, OutEvaluatedValue) end
---@param InFocus float
---@param InZoom float
---@param OutEvaluatedValue FFocalLengthInfo
---@return boolean
function ULensFile:EvaluateFocalLength(InFocus, InZoom, OutEvaluatedValue) end
---@param InFocus float
---@param InZoom float
---@param OutEvaluatedValue FDistortionInfo
---@return boolean
function ULensFile:EvaluateDistortionParameters(InFocus, InZoom, OutEvaluatedValue) end
---@param InFocus float
---@param InZoom float
---@param InFilmback FVector2D
---@param InLensHandler ULensDistortionModelHandlerBase
---@return boolean
function ULensFile:EvaluateDistortionData(InFocus, InZoom, InFilmback, InLensHandler) end
---@param InDataCategory ELensDataCategory
function ULensFile:ClearData(InDataCategory) end
function ULensFile:ClearAll() end
---@param NewFocus float
---@param NewZoom float
---@param NewPoint FSTMapInfo
function ULensFile:AddSTMapPoint(NewFocus, NewZoom, NewPoint) end
---@param NewFocus float
---@param NewZoom float
---@param NewPoint FNodalPointOffset
function ULensFile:AddNodalOffsetPoint(NewFocus, NewZoom, NewPoint) end
---@param NewFocus float
---@param NewZoom float
---@param NewPoint FImageCenterInfo
function ULensFile:AddImageCenterPoint(NewFocus, NewZoom, NewPoint) end
---@param NewFocus float
---@param NewZoom float
---@param NewFocalLength FFocalLengthInfo
function ULensFile:AddFocalLengthPoint(NewFocus, NewZoom, NewFocalLength) end
---@param NewFocus float
---@param NewZoom float
---@param NewPoint FDistortionInfo
---@param NewFocalLength FFocalLengthInfo
function ULensFile:AddDistortionPoint(NewFocus, NewZoom, NewPoint, NewFocalLength) end


---@class ULensModel : UObject
local ULensModel = {}


---@class USphericalLensDistortionModelHandler : ULensDistortionModelHandlerBase
local USphericalLensDistortionModelHandler = {}


---@class USphericalLensModel : ULensModel
local USphericalLensModel = {}


